/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import cofh.api.tileentity.ISecurable;
import cofh.lib.util.helpers.StringHelper;
import com.google.common.base.Strings;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.EnumConnectionState;
import net.minecraft.network.INetHandler;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;

public class SecurityHelper {
    public static final GameProfile UNKNOWN_GAME_PROFILE = new GameProfile(UUID.fromString("1ef1a6f0-87bc-4e78-0a0b-c6824eb787ea"), "[None]");
    private static boolean setup = false;
    private static UUID cachedId;

    public static void setup() {
        if (setup) {
            return;
        }
        EnumConnectionState.PLAY.func_150755_b().put((Object)-26, Login.S__PacketSendUUID.class);
        Map map = (Map)ReflectionHelper.getPrivateValue(EnumConnectionState.class, null, (String[])new String[]{"field_150761_f"});
        map.put(Login.S__PacketSendUUID.class, EnumConnectionState.PLAY);
        FMLCommonHandler.instance().bus().register((Object)new Login.S__PacketSendUUID());
        setup = true;
    }

    private SecurityHelper() {
    }

    public static boolean isDefaultUUID(UUID uUID) {
        return uUID == null || uUID.version() == 4 && uUID.variant() == 0;
    }

    public static UUID getID(EntityPlayer entityPlayer) {
        if (MinecraftServer.func_71276_C() != null && MinecraftServer.func_71276_C().func_71278_l()) {
            return entityPlayer.func_146103_bH().getId();
        }
        return SecurityHelper.getClientId(entityPlayer);
    }

    private static UUID getClientId(EntityPlayer entityPlayer) {
        if (entityPlayer != Minecraft.func_71410_x().field_71439_g) {
            return entityPlayer.func_146103_bH().getId();
        }
        if (cachedId == null) {
            cachedId = Minecraft.func_71410_x().field_71439_g.func_146103_bH().getId();
        }
        return cachedId;
    }

    public static NBTTagCompound setItemStackTagSecure(NBTTagCompound nBTTagCompound, ISecurable iSecurable) {
        if (iSecurable == null) {
            return null;
        }
        if (nBTTagCompound == null) {
            nBTTagCompound = new NBTTagCompound();
        }
        nBTTagCompound.func_74757_a("Secure", true);
        nBTTagCompound.func_74774_a("Access", (byte)iSecurable.getAccess().ordinal());
        nBTTagCompound.func_74778_a("OwnerUUID", iSecurable.getOwner().getId().toString());
        nBTTagCompound.func_74778_a("Owner", iSecurable.getOwner().getName());
        return nBTTagCompound;
    }

    public static void addOwnerInformation(ItemStack itemStack, List<String> list) {
        if (SecurityHelper.isSecure(itemStack)) {
            boolean bl = itemStack.field_77990_d.func_74764_b("OwnerUUID");
            if (!itemStack.field_77990_d.func_74764_b("Owner") && !bl) {
                list.add(StringHelper.localize("info.cofh.owner") + ": " + StringHelper.localize("info.cofh.none"));
            } else if (bl && itemStack.field_77990_d.func_74764_b("Owner")) {
                list.add(StringHelper.localize("info.cofh.owner") + ": " + itemStack.field_77990_d.func_74779_i("Owner") + " \u0378");
            } else {
                list.add(StringHelper.localize("info.cofh.owner") + ": " + StringHelper.localize("info.cofh.anotherplayer"));
            }
        }
    }

    public static void addAccessInformation(ItemStack itemStack, List<String> list) {
        if (SecurityHelper.isSecure(itemStack)) {
            String string = "";
            switch (itemStack.field_77990_d.func_74771_c("Access")) {
                case 0: {
                    string = StringHelper.localize("info.cofh.accessPublic");
                    break;
                }
                case 1: {
                    string = StringHelper.localize("info.cofh.accessRestricted");
                    break;
                }
                case 2: {
                    string = StringHelper.localize("info.cofh.accessPrivate");
                }
            }
            list.add(StringHelper.localize("info.cofh.access") + ": " + string);
        }
    }

    public static boolean isSecure(ItemStack itemStack) {
        return itemStack.field_77990_d == null ? false : itemStack.field_77990_d.func_74764_b("Secure");
    }

    public static ItemStack setSecure(ItemStack itemStack) {
        if (SecurityHelper.isSecure(itemStack)) {
            return itemStack;
        }
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.field_77990_d.func_74757_a("Secure", true);
        itemStack.field_77990_d.func_74774_a("Access", (byte)0);
        return itemStack;
    }

    public static ItemStack removeSecure(ItemStack itemStack) {
        if (!SecurityHelper.isSecure(itemStack)) {
            return itemStack;
        }
        itemStack.field_77990_d.func_82580_o("Secure");
        itemStack.field_77990_d.func_82580_o("Access");
        itemStack.field_77990_d.func_82580_o("OwnerUUID");
        itemStack.field_77990_d.func_82580_o("Owner");
        if (itemStack.field_77990_d.func_82582_d()) {
            itemStack.field_77990_d = null;
        }
        return itemStack;
    }

    public static boolean setAccess(ItemStack itemStack, ISecurable.AccessMode accessMode) {
        if (!SecurityHelper.isSecure(itemStack)) {
            return false;
        }
        itemStack.field_77990_d.func_74774_a("Access", (byte)accessMode.ordinal());
        return true;
    }

    public static ISecurable.AccessMode getAccess(ItemStack itemStack) {
        return itemStack.field_77990_d == null ? ISecurable.AccessMode.PUBLIC : ISecurable.AccessMode.values()[itemStack.field_77990_d.func_74771_c("Access")];
    }

    public static boolean setOwner(ItemStack itemStack, GameProfile gameProfile) {
        if (!SecurityHelper.isSecure(itemStack)) {
            return false;
        }
        itemStack.func_77983_a("OwnerUUID", (NBTBase)new NBTTagString(gameProfile.getId().toString()));
        itemStack.func_77983_a("Owner", (NBTBase)new NBTTagString(gameProfile.getName()));
        return true;
    }

    public static GameProfile getOwner(ItemStack itemStack) {
        if (itemStack.field_77990_d != null) {
            NBTTagCompound nBTTagCompound = itemStack.field_77990_d;
            String string = nBTTagCompound.func_74779_i("OwnerUUID");
            String string2 = nBTTagCompound.func_74779_i("Owner");
            if (!Strings.isNullOrEmpty((String)string)) {
                return new GameProfile(UUID.fromString(string), string2);
            }
            if (!Strings.isNullOrEmpty((String)string2)) {
                return new GameProfile(UUID.fromString(PreYggdrasilConverter.func_152719_a((String)string2)), string2);
            }
        }
        return UNKNOWN_GAME_PROFILE;
    }

    public static GameProfile getProfile(UUID uUID, String string) {
        GameProfile gameProfile = MinecraftServer.func_71276_C().func_152358_ax().func_152652_a(uUID);
        if (gameProfile == null) {
            GameProfile gameProfile2 = new GameProfile(uUID, string);
            gameProfile = MinecraftServer.func_71276_C().func_147130_as().fillProfileProperties(gameProfile2, true);
            if (gameProfile != gameProfile2) {
                MinecraftServer.func_71276_C().func_152358_ax().func_152649_a(gameProfile);
            }
        }
        return gameProfile;
    }

    public static String getOwnerName(ItemStack itemStack) {
        boolean bl;
        NBTTagCompound nBTTagCompound = itemStack.field_77990_d;
        if (nBTTagCompound == null || !(bl = nBTTagCompound.func_74764_b("OwnerUUID")) && !nBTTagCompound.func_74764_b("Owner")) {
            return "[None]";
        }
        return bl ? itemStack.field_77990_d.func_74779_i("Owner") : StringHelper.localize("info.cofh.anotherplayer");
    }

    static {
        SecurityHelper.setup();
    }

    private static class Login {
        private Login() {
        }

        public static class S__PacketSendUUID
        extends Packet {
            private UUID id;

            @SubscribeEvent
            public void login(PlayerEvent.PlayerLoggedInEvent playerLoggedInEvent) {
                ((EntityPlayerMP)playerLoggedInEvent.player).field_71135_a.func_147359_a((Packet)new S__PacketSendUUID(playerLoggedInEvent.player));
            }

            public S__PacketSendUUID() {
            }

            public S__PacketSendUUID(EntityPlayer entityPlayer) {
                this.id = entityPlayer.func_146103_bH().getId();
            }

            public void func_148837_a(PacketBuffer packetBuffer) throws IOException {
                this.id = new UUID(packetBuffer.readLong(), packetBuffer.readLong());
            }

            public void func_148840_b(PacketBuffer packetBuffer) throws IOException {
                packetBuffer.writeLong(this.id.getMostSignificantBits());
                packetBuffer.writeLong(this.id.getLeastSignificantBits());
            }

            public boolean func_148836_a() {
                return true;
            }

            public void func_148833_a(INetHandler iNetHandler) {
                cachedId = this.id;
            }
        }
    }
}

